package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestComment extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		Comment comment = Comment.findById(-1);
		Assert.assertNull(comment);

		// prime the mock hash
		ResearchStudy.findById(1);

		List<DartRequest> rlist = DartRequest.listAll();
		Assert.assertNotNull(rlist);
		Assert.assertTrue(rlist.size() > 0);

		DartRequest request = rlist.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);
		Assert.assertNotNull(request.getActivity());
		Assert.assertTrue(request.getActivity().getId() > 0);
		
		comment = Comment.create("test description", request, "DNS", "test comment text");
		
		Assert.assertNotNull(comment);
		Assert.assertTrue(comment.getId() > 0);

		Comment c2 = Comment.findById(comment.getId());
		Assert.assertNotNull(c2);
		Assert.assertTrue(c2.getId() > 0);
		Assert.assertEquals(c2,comment);
		
		List<Comment> cList = Comment.listByActivityId(request.getActivity().getId());
		Assert.assertNotNull(cList);
		Assert.assertTrue(cList.size() > 0);
		Assert.assertTrue(cList.contains(comment));
		
		List<NestableComment> ncList = Comment.listByRequestId(request.getId());
		Assert.assertNotNull(ncList);
		Assert.assertTrue(ncList.size() > 0);
		
	}

	@Test
	public void testThree() throws Exception {
		Comment comment = Comment.findById(-1);
		Assert.assertNull(comment);

		// prime the mock hash
		ResearchStudy.findById(1);
		
		List<DartRequest> rlist = DartRequest.listAll();
		Assert.assertNotNull(rlist);
		Assert.assertTrue(rlist.size() > 0);

		DartRequest request = rlist.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);
		Assert.assertNotNull(request.getActivity());
		Assert.assertTrue(request.getActivity().getId() > 0);
		
		comment = Comment.create("test description", request, "DNS", "test comment text");
		
		Assert.assertNotNull(comment);
		Assert.assertTrue(comment.getId() > 0);

		Comment c2 = Comment.create("test two", request, "DNS", "test comment text two");
		Assert.assertNotNull(c2);
		Assert.assertTrue(c2.getId() > 0);

		c2.setPreviousComment(comment);
		
		Assert.assertNotNull(c2.getPreviousComment());
		Assert.assertNotNull(comment.getNextComments());
		Assert.assertTrue(comment.getNextComments().contains(c2));
		
		Comment c3 = Comment.create("test three", request, "DNS", "test comment text three");
		Assert.assertNotNull(c3);
		Assert.assertTrue(c3.getId() > 0);

		c3.setPreviousComment(comment);

		Assert.assertNotNull(c3.getPreviousComment());
		Assert.assertNotNull(comment.getNextComments());
		Assert.assertTrue(comment.getNextComments().contains(c3));

		Comment c4 = Comment.create("test four", request, "DNS", "test comment text four");
		Assert.assertNotNull(c4);
		Assert.assertTrue(c4.getId() > 0);

		// changing the previous comment removes this from the next comments of the comment that is no longer previous
		c3.setPreviousComment(c4);

		Assert.assertNull(c4.getPreviousComment());  // the default state
		Assert.assertNotNull(c3.getPreviousComment());
		Assert.assertNotNull(c3.getNextComments());
		Assert.assertTrue(c4.getNextComments().contains(c3));
		Assert.assertFalse(comment.getNextComments().contains(c3));
	}

	@Test
	public void testTwo() throws Exception {
		Comment comment = Comment.findById(-1);
		Assert.assertNull(comment);

		// prime the mock hash
		ResearchStudy.findById(1);
		
		List<DartRequest> rlist = DartRequest.listAll();
		Assert.assertNotNull(rlist);
		Assert.assertTrue(rlist.size() > 0);

		DartRequest request = rlist.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);
		Assert.assertNotNull(request.getActivity());
		Assert.assertTrue(request.getActivity().getId() > 0);
		
		comment = Comment.create("test description", request, "DNS", "test comment text");
		
		Assert.assertNotNull(comment);
		Assert.assertTrue(comment.getId() > 0);
		
		comment.setText("this is test");

		Comment c2 = Comment.findById(comment.getId());
		Assert.assertNotNull(c2);
		Assert.assertTrue(c2.getId() > 0);
		Assert.assertEquals(c2,comment);
		Assert.assertNotNull(c2.getRequest());
		Assert.assertEquals(c2.getRequest(), request);

		Assert.assertEquals(c2.getText(), "this is test");
	}
}
